import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { memo, useCallback } from "react";
import { PORTRAIT_BREAKPOINT } from "../../constants.mjs";
import { unwrapLabel, useActions } from "../../context/actions.mjs";
import { useBreakpoint } from "../../context/breakpoints.mjs";
import { useTldrawUiComponents } from "../../context/components.mjs";
import { useLocalStorageState } from "../../hooks/useLocalStorageState.mjs";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { kbdStr } from "../../kbd-utils.mjs";
import { TldrawUiButton } from "../primitives/Button/TldrawUiButton.mjs";
import { TldrawUiButtonIcon } from "../primitives/Button/TldrawUiButtonIcon.mjs";
const DefaultNavigationPanel = memo(function DefaultNavigationPanel2() {
  const actions = useActions();
  const msg = useTranslation();
  const breakpoint = useBreakpoint();
  const [collapsed, setCollapsed] = useLocalStorageState("minimap", true);
  const toggleMinimap = useCallback(() => {
    setCollapsed((s) => !s);
  }, [setCollapsed]);
  const { ZoomMenu, Minimap } = useTldrawUiComponents();
  if (breakpoint < PORTRAIT_BREAKPOINT.MOBILE) {
    return null;
  }
  return /* @__PURE__ */ jsxs("div", { className: "tlui-navigation-panel", children: [
    /* @__PURE__ */ jsx("div", { className: "tlui-buttons__horizontal", children: ZoomMenu && breakpoint < PORTRAIT_BREAKPOINT.TABLET ? /* @__PURE__ */ jsx(ZoomMenu, {}) : collapsed ? /* @__PURE__ */ jsxs(Fragment, { children: [
      ZoomMenu && /* @__PURE__ */ jsx(ZoomMenu, {}),
      Minimap && /* @__PURE__ */ jsx(
        TldrawUiButton,
        {
          type: "icon",
          "data-testid": "minimap.toggle-button",
          title: msg("navigation-zone.toggle-minimap"),
          className: "tlui-navigation-panel__toggle",
          onClick: toggleMinimap,
          children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: collapsed ? "chevrons-ne" : "chevrons-sw" })
        }
      )
    ] }) : /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(
        TldrawUiButton,
        {
          type: "icon",
          "data-testid": "minimap.zoom-out",
          title: `${msg(unwrapLabel(actions["zoom-out"].label))} ${kbdStr(actions["zoom-out"].kbd)}`,
          onClick: () => actions["zoom-out"].onSelect("navigation-zone"),
          children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: "minus" })
        }
      ),
      ZoomMenu && /* @__PURE__ */ jsx(ZoomMenu, {}),
      /* @__PURE__ */ jsx(
        TldrawUiButton,
        {
          type: "icon",
          "data-testid": "minimap.zoom-in",
          title: `${msg(unwrapLabel(actions["zoom-in"].label))} ${kbdStr(actions["zoom-in"].kbd)}`,
          onClick: () => actions["zoom-in"].onSelect("navigation-zone"),
          children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: "plus" })
        }
      ),
      Minimap && /* @__PURE__ */ jsx(
        TldrawUiButton,
        {
          type: "icon",
          "data-testid": "minimap.toggle-button",
          title: msg("navigation-zone.toggle-minimap"),
          className: "tlui-navigation-panel__toggle",
          onClick: toggleMinimap,
          children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: collapsed ? "chevrons-ne" : "chevrons-sw" })
        }
      )
    ] }) }),
    Minimap && breakpoint >= PORTRAIT_BREAKPOINT.TABLET && !collapsed && /* @__PURE__ */ jsx(Minimap, {})
  ] });
});
export {
  DefaultNavigationPanel
};
//# sourceMappingURL=DefaultNavigationPanel.mjs.map
